#property link      "http://sonyirwana.blogspot.com"

#property indicator_separate_window
#property indicator_levelcolor Gray
#property indicator_buffers 4
#property indicator_color1 RoyalBlue
#property indicator_color2 Red
#property indicator_color3 Yellow
#property indicator_color4 Black

int g_period_76 = 5;
int g_period_80 = 13;
int g_period_84 = 1;
double gd_88 = 0.0;
int g_fontsize_96 = 8;
int g_color_100 = Black;
double gda_104[];
double g_ibuf_108[];
double g_ibuf_112[];
double g_ibuf_116[];
double g_ibuf_120[];

int init() {
   SetIndexStyle(0, DRAW_HISTOGRAM);
   SetIndexStyle(1, DRAW_HISTOGRAM);
   SetIndexStyle(2, DRAW_HISTOGRAM);
   SetIndexStyle(3, DRAW_NONE);
   SetIndexDrawBegin(1, g_period_84);
   IndicatorDigits(1);
   SetIndexBuffer(0, g_ibuf_108);
   SetIndexBuffer(1, g_ibuf_112);
   SetIndexBuffer(2, g_ibuf_116);
   SetIndexBuffer(3, g_ibuf_120);
   IndicatorShortName("FXSONI TREND ANALIZER v.1a");
   SetIndexLabel(0, "UP Trend");
   SetIndexLabel(1, "Down Trend");
   SetIndexLabel(2, "Equivalent");
   SetIndexLabel(3, "Signal");
   return (0);
}

int deinit() {
   string l_name_0 = WindowExpertName() + "," + Symbol() + "," + Period();
   ObjectDelete(l_name_0);
   return (0);
}

int start() {
   double lda_20[];
   int li_32;
   int l_ind_counted_4 = IndicatorCounted();
   int li_0 = MathMin(Bars - g_period_80, Bars - l_ind_counted_4 + 1);
   ArrayResize(gda_104, li_0);
   ArraySetAsSeries(gda_104, TRUE);
   for (int li_8 = 0; li_8 < li_0; li_8++) gda_104[li_8] = (iMA(NULL, 0, g_period_76, 0, MODE_EMA, PRICE_CLOSE, li_8) - iMA(NULL, 0, g_period_80, 0, MODE_EMA, PRICE_CLOSE, li_8)) / Point;
   for (li_8 = li_0 - 2; li_8 >= 0; li_8--) {
      if (MathAbs(gda_104[li_8] - (gda_104[li_8 + 1])) < gd_88) {
         g_ibuf_116[li_8] = gda_104[li_8];
         g_ibuf_108[li_8] = 0;
         g_ibuf_112[li_8] = 0;
      } else {
         if (gda_104[li_8] > gda_104[li_8 + 1]) {
            g_ibuf_108[li_8] = gda_104[li_8];
            g_ibuf_112[li_8] = 0;
            g_ibuf_116[li_8] = 0;
         } else {
            g_ibuf_112[li_8] = gda_104[li_8];
            g_ibuf_108[li_8] = 0;
            g_ibuf_116[li_8] = 0;
         }
      }
   }
   for (li_8 = 0; li_8 < li_0; li_8++) g_ibuf_120[li_8] = iMAOnArray(gda_104, Bars, g_period_84, 0, MODE_SMA, li_8);
   double ld_12 = (iMA(NULL, 0, g_period_76, 0, MODE_EMA, PRICE_CLOSE, 1) - iMA(NULL, 0, g_period_80, 0, MODE_EMA, PRICE_CLOSE, 1)) / Point;
   ArrayResize(lda_20, Bars);
   ArraySetAsSeries(lda_20, TRUE);
   ArrayCopy(lda_20, Close, 0, 0, ArraySize(lda_20));
   double ld_24 = (iMAOnArray(lda_20, 0, g_period_76, 0, MODE_EMA, 0) - iMAOnArray(lda_20, 0, g_period_80, 0, MODE_EMA, 0)) / Point;
   if (ld_24 < ld_12) {
      while (ld_24 < ld_12) {
         li_32++;
         lda_20[0] += Point;
         ld_24 = (iMAOnArray(lda_20, 0, g_period_76, 0, MODE_EMA, 0) - iMAOnArray(lda_20, 0, g_period_80, 0, MODE_EMA, 0)) / Point;
      }
   } else {
      while (ld_24 > ld_12) {
         li_32--;
         lda_20[0] = lda_20[0] - Point;
         ld_24 = (iMAOnArray(lda_20, 0, g_period_76, 0, MODE_EMA, 0) - iMAOnArray(lda_20, 0, g_period_80, 0, MODE_EMA, 0)) / Point;
      }
   }
   string l_name_36 = WindowExpertName() + "," + Symbol() + "," + Period();
   if (ObjectFind(l_name_36) < 0) ObjectCreate(l_name_36, OBJ_TEXT, WindowFind(WindowExpertName() + " (" + g_period_76 + "," + g_period_80 + "," + g_period_84 + ")"), Time[0] + 60 * Period(), gda_104[0] / 2.0);
   else ObjectMove(l_name_36, 0, Time[0] + 60 * Period(), gda_104[0] / 2.0);
   if (li_32 != 0) ObjectSetText(l_name_36, DoubleToStr(li_32, 0), g_fontsize_96, "Courier", g_color_100);
   else ObjectSetText(l_name_36, " ", g_fontsize_96, "Courier", g_color_100);
   return (0);
}